/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.tasks.spi;

import com.ibm.hwmca.base.pa.problem.ManualPaWorkRequest;
import com.ibm.hwmca.base.pa.problem.ManualPaWorkThread;
import com.ibm.hwmca.base.pa.util.ErrorListData;
import com.ibm.hwmca.base.pa.util.ErrorListElement;
import com.ibm.hwmca.base.pa.util.ListReport;
import com.ibm.hwmca.base.pa.util.ManualPaSummaryElement;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.interfaces.ManualPaServiceDataProvider;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.ReportListenerAdapter;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkThread;
import com.ibm.hwmca.xfw.pa.tasks.XFrameManualProblemAnalysisServerTasklet;
import com.ibm.hwmca.xfw.panel.pa.manual.ErrorBean;
import com.ibm.hwmca.xfw.panel.pa.manual.ErrorListBean;
import com.ibm.hwmca.xfw.panel.pa.manual.TracetBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ManualProblemAnalysisServerTasklet
extends XFrameManualProblemAnalysisServerTasklet {
    private static final String TRACE_MASKT = "XPAMPSTT";
    private static final String TRACE_MASKF = "XPAMPSTF";
    private static final String TRACE_MASKD = "XPAMPSTD";
    private static final boolean UNIT_TEST = true;
    private static final String VERSION = "Ver 1.0, Rel 0.2";
    private static final String SERVICE_INTERFACE = "com.ibm.hwmca.fw.interfaces.ManualPaServiceDataProvider";
    public static final int RECORD_TYPE_CHANNEL = 1;
    public static final int RECORD_TYPE_CPC = 2;
    private HashMap _systemMap = new HashMap(32);
    private HashMap _areaMap = new HashMap(50);
    private HashMap _problemMap = new HashMap(50);
    private int _workingIdentifier = 0;
    private String _system = null;
    private int _totalRequest = 1;
    private List _outerList = null;
    private ManagedObject[] _innerObjectArray = null;
    private ObjectId[] _objectIdArray = null;

    public void logException(Throwable t) {
        Trace.trace(TRACE_MASKT, "--> logException()");
        try {
            this.destroyBusyDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<-- logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorListBean getErrorListBean() throws TaskletException {
        int i;
        Trace.trace(TRACE_MASKT, "--> getErrorListBean() Ver 1.0, Rel 0.2");
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "pa.manual.title"), new LocalizableText(BaseTextBundle.getBundleName(), "pa.busy.text"));
        if (this.getPresentationTaskParms().getTargetIds() == null) {
            Trace.trace(TRACE_MASKD, "No targets. Running against the console.");
            this._outerList = new ArrayList(1);
            this._innerObjectArray[0] = HMC.getHMC();
            this._objectIdArray[0] = HMC.getHMC().getObjectId();
            this._outerList.add(this._innerObjectArray[0]);
        } else {
            this._totalRequest = this.getPresentationTaskParms().getTargetIds().length;
            List parmOuterList = this.getPresentationTaskParms().getGroupedTargetIds();
            this._objectIdArray = this.getPresentationTaskParms().getTargetIds();
            Trace.trace(TRACE_MASKD, "got objectIdArray of " + this._objectIdArray.length + "elements");
            int outerSize = parmOuterList.size();
            Trace.trace(TRACE_MASKD, "outer list size = " + outerSize);
            this._outerList = new ArrayList(outerSize);
            for (i = 0; i < outerSize; ++i) {
                this._outerList.add(this.getObjectsForIds((ObjectId[])parmOuterList.get(i)));
            }
        }
        CompletionReport[] listReport = new CompletionReport[this._totalRequest];
        Trace.trace(TRACE_MASKD, "got " + this._totalRequest + " targets to handle.");
        Trace.trace(TRACE_MASKD, "got an outerList of " + this._outerList.size() + " elements");
        ReportListenerAdapter reportAdapter = new ReportListenerAdapter(this, listReport, this._objectIdArray);
        for (i = 0; i < this._outerList.size(); ++i) {
            ManualPaWorkThread worker = new ManualPaWorkThread();
            Trace.trace(TRACE_MASKD, "start work thread [" + i + "]");
            ManualPaWorkRequest workRequest = new ManualPaWorkRequest();
            workRequest.setRequestType(1);
            workRequest.setParameter(this._outerList.get(i));
            workRequest.setTargetArray((ManagedObject[])this._outerList.get(i));
            workRequest.setReportListener(reportAdapter);
            Trace.trace(TRACE_MASKD, "listener is [" + reportAdapter + "]");
            try {
                WorkThread.invokeAsync(worker, worker, workRequest, "Manual PA getErrorListBean() work thread");
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Got an exception from the work thread.");
                this.destroyBusyDialog();
                throw new TaskletException(e);
            }
        }
        try {
            ManualProblemAnalysisServerTasklet i2 = this;
            synchronized (i2) {
                while (!reportAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            throw new TaskletException(thrown);
        }
        Trace.trace(TRACE_MASKD, "done. get the data");
        ErrorListBean elb = new ErrorListBean();
        boolean displayFailure = false;
        int failureCount = 0;
        long endTime = Long.MIN_VALUE;
        long startTime = Long.MAX_VALUE;
        Trace.trace(TRACE_MASKF, "got " + listReport.length + " reports to process");
        for (int i3 = 0; i3 < listReport.length; ++i3) {
            if (listReport[i3].getCompletionCode().equals(CompletionReportCode.FAIL)) {
                Trace.trace(TRACE_MASKD, "got a failure");
                displayFailure = true;
                ++failureCount;
                continue;
            }
            ErrorListData listData = (ErrorListData)((ListReport)listReport[i3]).getData();
            if (endTime < listData.getEndTime()) {
                endTime = listData.getEndTime();
            }
            if (startTime > listData.getStartTime()) {
                startTime = listData.getStartTime();
            }
            Iterator listIt = ((ListReport)listReport[i3]).getList().iterator();
            Object sdp = ((ListReport)listReport[i3]).getSdp();
            while (listIt.hasNext()) {
                ErrorListElement errorElement = (ErrorListElement)listIt.next();
                String systemKey = errorElement.getSystem();
                String areaString = errorElement.getAreaString();
                String areaKey = systemKey + ";" + areaString;
                this._systemMap.put(systemKey, sdp);
                this._areaMap.put(areaKey, errorElement);
                Trace.trace(TRACE_MASKD, "errorElement.getObjectId is [" + errorElement.getObjectId() + "]");
                Trace.trace(TRACE_MASKD, "errorElement.getID is " + errorElement.getId());
                Trace.trace(TRACE_MASKD, "Listreport is " + listReport[i3]);
                elb.addDataRow(systemKey, areaString, errorElement.getErrorCount());
            }
        }
        this.destroyBusyDialog();
        if (displayFailure) {
            Trace.trace(TRACE_MASKD, "got a failure report");
            LocalizableText ans = this.showMessageBox(true, new LocalizableText("Manual PA"), new BaseMessageText("XPA9999"), MsgType.INFORMATION_MESSAGE, null);
        }
        if (elb.getErrorTableRowCount() == 0) {
            LocalizableText ans = this.showMessageBox(true, new BaseMessageText("XPA1001"), new BaseMessageText("XPA1009"), MsgType.INFORMATION_MESSAGE, null);
        } else {
            UserContext userContext = UserContext.getCurrentUserContext();
            SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss:SS  MM-dd-yyyy", userContext.getLocale());
            formatter.setTimeZone(userContext.getTimeZone());
            elb.setBeginningTimeOutput(formatter.format(new Date(startTime)));
            elb.setEndTimeOutput(formatter.format(new Date(endTime)));
        }
        return elb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorBean getViewAllBean(String system) throws TaskletException {
        Trace.trace(TRACE_MASKT, "[Z-series] ManualProblemAnalysisTasklet.getViewAllBean(" + system + ")");
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "pa.manual.title"), new LocalizableText(BaseTextBundle.getBundleName(), "pa.busy.text"));
        CompletionReport[] listReport = new CompletionReport[this._totalRequest];
        Trace.trace(TRACE_MASKD, "got " + this._totalRequest + " targets to handle.");
        Trace.trace(TRACE_MASKD, "got an outerList of " + this._outerList.size() + " elements");
        ReportListenerAdapter reportAdapter = new ReportListenerAdapter(this, listReport, this._objectIdArray);
        for (int i = 0; i < this._outerList.size(); ++i) {
            ManualPaWorkThread worker = new ManualPaWorkThread();
            Trace.trace(TRACE_MASKD, "start work thread [" + i + "]");
            ManualPaWorkRequest workRequest = new ManualPaWorkRequest();
            workRequest.setRequestType(2);
            workRequest.setParameter(this._outerList.get(i));
            workRequest.setTargetArray((ManagedObject[])this._outerList.get(i));
            workRequest.setReportListener(reportAdapter);
            Trace.trace(TRACE_MASKD, "listener is [" + reportAdapter + "]");
            try {
                WorkThread.invokeAsync(worker, worker, workRequest, "Manual PA getViewAllBean() work thread");
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Got an exception from the work thread.");
                this.destroyBusyDialog();
                throw new TaskletException(e);
            }
        }
        try {
            ManualProblemAnalysisServerTasklet i = this;
            synchronized (i) {
                while (!reportAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            throw new TaskletException(thrown);
        }
        Trace.trace(TRACE_MASKD, "done. get the data");
        ErrorBean eb = null;
        if (listReport[0].getCompletionCode().equals(CompletionReportCode.FAIL)) {
            this.destroyBusyDialog();
            LocalizableText ans = this.showMessageBox(true, new LocalizableText("Manual PA"), new BaseMessageText("XPA9999"), MsgType.INFORMATION_MESSAGE, null);
        } else {
            Iterator anIt = ((ListReport)listReport[0]).getList().iterator();
            ManagedObject aManagedObject = (ManagedObject)this.getObjectForId(((ListReport)listReport[0]).getObjectId());
            String name = aManagedObject.getUIInfo().getTitle();
            eb = new ErrorBean(name);
            int offset = 0;
            while (anIt.hasNext()) {
                ManualPaSummaryElement anElement = (ManualPaSummaryElement)anIt.next();
                if (anElement.getErrorType() == 1) {
                    eb.setChannelPath(anElement.getChpid());
                    eb.setInterfaceOutput(anElement.getLocation());
                }
                this._problemMap.put(new Integer(offset), anElement);
                eb.addDataRow(new Date(anElement.getTime()), anElement.getSummaryMessage());
                ++offset;
            }
            this.destroyBusyDialog();
        }
        return eb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorBean getViewSelectedBean(String system, String area) throws TaskletException {
        Trace.trace(TRACE_MASKT, "[Z-series] ManualProblemAnalysisTasklet.getViewSelectedBean(" + system + ";" + area + ")");
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "pa.manual.title"), new LocalizableText(BaseTextBundle.getBundleName(), "pa.busy.text"));
        String key = system + ";" + area;
        this._system = system;
        Trace.trace(TRACE_MASKD, "key = [" + key + "]");
        ManualPaServiceDataProvider sdp = (ManualPaServiceDataProvider)this._systemMap.get(system);
        if (sdp != null) {
            Trace.trace(TRACE_MASKD, "found the sdp to use");
        } else {
            Trace.trace(TRACE_MASKD, "didn't find the sdp");
            Trace.trace(TRACE_MASKD, "dsp info size =" + this._areaMap.size());
        }
        ErrorListElement element = (ErrorListElement)this._areaMap.get(key);
        if (element != null) {
            Trace.trace(TRACE_MASKD, "found the element to use");
        }
        ObjectId[] objectIdArray = new ObjectId[]{element.getObjectId()};
        Trace.trace(TRACE_MASKD, "element.getObjectID() is " + element.getObjectId());
        Trace.trace(TRACE_MASKD, "objectId to wait for is " + objectIdArray[0]);
        CompletionReport[] listReport = new CompletionReport[1];
        Trace.trace(TRACE_MASKD, "listReport.length = " + listReport.length);
        Trace.trace(TRACE_MASKD, "objectIdArray.length = " + objectIdArray.length);
        ReportListenerAdapter reportAdapter = new ReportListenerAdapter(this, listReport, objectIdArray);
        Trace.trace(TRACE_MASKD, "report Adapter is" + reportAdapter);
        ManualPaWorkThread worker = new ManualPaWorkThread();
        Trace.trace(TRACE_MASKD, "start work thread ");
        ManualPaWorkRequest workRequest = new ManualPaWorkRequest();
        workRequest.setRequestType(3);
        workRequest.setParameter(element);
        workRequest.setSDP(sdp);
        workRequest.setReportListener(reportAdapter);
        Trace.trace(TRACE_MASKD, "listener is [" + reportAdapter + "]");
        try {
            WorkThread.invokeAsync(worker, worker, workRequest, "Manual PA getViewSelectedBean() work thread");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Got an exception from the work thread.");
            this.destroyBusyDialog();
            throw new TaskletException(e);
        }
        try {
            ManualProblemAnalysisServerTasklet e = this;
            synchronized (e) {
                while (!reportAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            throw new TaskletException(thrown);
        }
        Trace.trace(TRACE_MASKD, "done. get the data");
        ErrorBean eb = null;
        if (listReport[0].getCompletionCode().equals(CompletionReportCode.FAIL)) {
            this.destroyBusyDialog();
            LocalizableText ans = this.showMessageBox(true, new LocalizableText("Manual PA"), new BaseMessageText("XPA9999"), MsgType.INFORMATION_MESSAGE, null);
        } else {
            Iterator anIt = ((ListReport)listReport[0]).getList().iterator();
            ManagedObject aManagedObject = (ManagedObject)this.getObjectForId(((ListReport)listReport[0]).getObjectId());
            String name = aManagedObject.getUIInfo().getTitle();
            eb = new ErrorBean(name);
            int offset = 0;
            while (anIt.hasNext()) {
                ManualPaSummaryElement anElement = (ManualPaSummaryElement)anIt.next();
                if (anElement.getErrorType() == 1) {
                    eb.setChannelPath(anElement.getChpid());
                    eb.setInterfaceOutput(anElement.getLocation());
                }
                this._problemMap.put(new Integer(offset), anElement);
                eb.addDataRow(new Date(anElement.getTime()), anElement.getSummaryMessage());
                ++offset;
            }
            this.destroyBusyDialog();
        }
        return eb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PanelBean getAnalysisBean(int selection) throws TaskletException {
        Trace.trace(TRACE_MASKT, "--> ManualProblemAnalysisTasklet.getAnalysisBean(" + selection + ")");
        this._workingIdentifier = selection;
        ManualPaSummaryElement element = (ManualPaSummaryElement)this._problemMap.get(new Integer(selection));
        if (element != null) {
            Trace.trace(TRACE_MASKD, "found the element to use");
        }
        PanelBean theBean = null;
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "pa.manual.title"), new LocalizableText(BaseTextBundle.getBundleName(), "pa.busy.text"));
        Trace.trace(TRACE_MASKD, "system = [" + this._system + "]");
        ManualPaServiceDataProvider sdp = element.getSdp();
        if (sdp != null) {
            Trace.trace(TRACE_MASKD, "found the sdp to use");
        }
        ObjectId[] objectIdArray = new ObjectId[]{element.getObjectId()};
        Trace.trace(TRACE_MASKD, "element.getObjectID() is " + element.getObjectId());
        Trace.trace(TRACE_MASKD, "objectId to wait for is " + objectIdArray[0]);
        CompletionReport[] listReport = new CompletionReport[1];
        Trace.trace(TRACE_MASKD, "listReport.length = " + listReport.length);
        Trace.trace(TRACE_MASKD, "objectIdArray.length = " + objectIdArray.length);
        ReportListenerAdapter reportAdapter = new ReportListenerAdapter(this, listReport, objectIdArray);
        Trace.trace(TRACE_MASKD, "report Adapter is" + reportAdapter);
        ManualPaWorkThread worker = new ManualPaWorkThread();
        Trace.trace(TRACE_MASKD, "start work thread ");
        ManualPaWorkRequest workRequest = new ManualPaWorkRequest();
        workRequest.setRequestType(4);
        workRequest.setParameter(element);
        workRequest.setSDP(sdp);
        workRequest.setReportListener(reportAdapter);
        Trace.trace(TRACE_MASKD, "listener is [" + reportAdapter + "]");
        try {
            WorkThread.invokeAsync(worker, worker, workRequest, "Manual PA getAnalysisBean() work thread");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Got an exception from the work thread.");
            this.destroyBusyDialog();
            throw new TaskletException(e);
        }
        try {
            ManualProblemAnalysisServerTasklet e = this;
            synchronized (e) {
                while (!reportAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            throw new TaskletException(thrown);
        }
        Trace.trace(TRACE_MASKD, "done. get the data");
        this.destroyBusyDialog();
        if (listReport[0].getCompletionCode().equals(CompletionReportCode.FAIL)) {
            LocalizableText ans = this.showMessageBox(true, new LocalizableText("Manual PA"), new BaseMessageText("XPA9999"), MsgType.INFORMATION_MESSAGE, null);
        } else {
            theBean = (PanelBean)listReport[0].getData();
        }
        Trace.trace(TRACE_MASKT, "<-- ManualProblemAnalysisTasklet.getAnalysisBean(" + selection + ")");
        return theBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestService() throws TaskletException {
        LocalizableText ans;
        Trace.trace(TRACE_MASKD, "--> ManualProblemAnalysisTasklet.requestService()");
        Trace.trace(TRACE_MASKD, "get service for " + this._workingIdentifier);
        ManualPaSummaryElement element = (ManualPaSummaryElement)this._problemMap.get(new Integer(this._workingIdentifier));
        if (element != null) {
            Trace.trace(TRACE_MASKD, "found the element to use");
        } else {
            Trace.trace(TRACE_MASKD, "couldn't find the element to use");
        }
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "pa.manual.title"), new LocalizableText(BaseTextBundle.getBundleName(), "pa.busy.text"));
        Trace.trace(TRACE_MASKD, "system = [" + this._system + "]");
        ManualPaServiceDataProvider sdp = element.getSdp();
        if (sdp != null) {
            Trace.trace(TRACE_MASKD, "found the sdp to use");
        }
        ObjectId[] objectIdArray = new ObjectId[]{element.getObjectId()};
        Trace.trace(TRACE_MASKD, "element.getObjectID() is " + element.getObjectId());
        Trace.trace(TRACE_MASKD, "objectId to wait for is " + objectIdArray[0]);
        CompletionReport[] listReport = new CompletionReport[1];
        Trace.trace(TRACE_MASKD, "listReport.length = " + listReport.length);
        Trace.trace(TRACE_MASKD, "objectIdArray.length = " + objectIdArray.length);
        ReportListenerAdapter reportAdapter = new ReportListenerAdapter(this, listReport, objectIdArray);
        Trace.trace(TRACE_MASKD, "report Adapter is" + reportAdapter);
        ManualPaWorkThread worker = new ManualPaWorkThread();
        Trace.trace(TRACE_MASKD, "start work thread ");
        ManualPaWorkRequest workRequest = new ManualPaWorkRequest();
        workRequest.setRequestType(5);
        workRequest.setParameter(element);
        workRequest.setSDP(sdp);
        workRequest.setReportListener(reportAdapter);
        Trace.trace(TRACE_MASKD, "listener is [" + reportAdapter + "]");
        try {
            WorkThread.invokeAsync(worker, worker, workRequest, "Manaul PA requestService() work thread");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Got an exception from the work thread.");
            this.destroyBusyDialog();
            throw new TaskletException(e);
        }
        try {
            ManualProblemAnalysisServerTasklet e = this;
            synchronized (e) {
                while (!reportAdapter.isFinished()) {
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {}
                }
            }
            Trace.trace(TRACE_MASKD, "Finshed.");
        }
        catch (Throwable thrown) {
            throw new TaskletException(thrown);
        }
        Trace.trace(TRACE_MASKD, "done. get the data");
        this.destroyBusyDialog();
        if (listReport[0].getCompletionCode().equals(CompletionReportCode.FAIL)) {
            ans = this.showMessageBox(true, new LocalizableText("Manual PA"), new BaseMessageText("XPA9999"), MsgType.INFORMATION_MESSAGE, null);
        }
        ans = this.showMessageBox(true, new LocalizableText("Manual PA"), new BaseMessageText("XPA7020"), MsgType.INFORMATION_MESSAGE, null);
        Trace.trace(TRACE_MASKD, "<-- ManualProblemAnalysisTasklet.requestService()");
    }

    public PanelBean getAnalysisTrace() throws TaskletException {
        System.out.println("[Z-series] ManualProblemAnalysisTasklet.getAnalysisTrace()");
        TracetBean ttb = new TracetBean();
        ttb.addContent("this is a long string of trace data that should be mono spaced");
        ttb.addContent("when it's displayed.");
        return ttb;
    }
}

